#!/bin/sh

MASTER_PAGE_ESXI_REMOVE_RESULT_OK=0
MASTER_PAGE_ESXI_REMOVE_RESULT_ERROR=1
MASTER_PAGE_ESXI_REMOVE_RESULT_CODE=${MASTER_PAGE_ESXI_REMOVE_RESULT_ERROR}

MASTER_PAGE_ESXI_REMOVE_RESULT_ROLLING=0
MASTER_PAGE_ESXI_REMOVE_RESULT_MSG=""

master_page_esxi_remove() {
    debug_print $0 $LINENO 'in function "master_page_esxi_remove"'
    
	tp_yesno \
		"${MASTER_PAGE_ESXI_REMOVE_TITLE}" \
		"${MASTER_PAGE_ESXI_REMOVE_TEXT}"

	if [ "${TP_YESNO_RESULT_SELECT}" != "${TP_YESNO_RESULT_YES}" ]; then
		MASTER_PAGE_ESXI_REMOVE_RESULT_CODE=$MASTER_PAGE_ESXI_REMOVE_RESULT_OK
		MASTER_PAGE_ESXI_REMOVE_RESULT_ROLLING=-1
		return
	fi
	
	slave_esxi_removed=0
	
	local rmv_ret
	rmv_ret=`php $CONS_BACKEND remove_cluster "${to_be_updated_sc_id}" "${CLST_PAGE_MAIN_MENU_TITLE}"`
	local ret="${?}"
    if [ "${ret}" -eq 0 ]; then
        sh notify_configuration_change.sh
        MASTER_PAGE_ESXI_REMOVE_RESULT_CODE=$MASTER_PAGE_ESXI_REMOVE_RESULT_OK
        MASTER_PAGE_ESXI_REMOVE_RESULT_ROLLING=1

        slave_esxi_removed=1
        return
    fi
    case "${ret}" in
        1)
            warning "${MASTER_PAGE_ESXI_REMOVE_INTERNAL_ERROR}" "${rmv_ret}"
            ;;
        2)
            MASTER_PAGE_ESXI_REMOVE_RESULT_MSG=${MASTER_PAGE_ESXI_REMOVE_CLUSTER_INACCESSIBLE}
            ;;
        *)
            MASTER_PAGE_ESXI_REMOVE_RESULT_MSG="${MASTER_PAGE_ESXI_REMOVE_INTERNAL_ERROR}: ${rmv_ret}"
            ;;
    esac
    MASTER_PAGE_ESXI_REMOVE_RESULT_CODE=$MASTER_PAGE_ESXI_REMOVE_RESULT_ERROR
    MASTER_PAGE_ESXI_REMOVE_RESULT_ROLLING=1
}